#Normality model for anomaly detection 
from scipy.spatial import distance
from sklearn.mixture import GaussianMixture
import numpy as np
import os
import torch.nn as nn
import tensorflow as tf
os.environ['NUMBAPRO_LIBDEVICE'] = "/usr/local/cuda-11.7/nvvm/libdevice"
os.environ['NUMBAPRO_NVVM'] = "/usr/local/cuda-11.7/nvvm/lib64/libnvvm.so"
os.environ['TF_CPP_MIN_LOG_LEVEL'] = '3'

# enabling gpu
gpu_devices = tf.config.experimental.list_physical_devices('GPU')
for device in gpu_devices:
    tf.config.experimental.set_memory_growth(device, True)

def detection_train_block(titles_compared,train_image_features):
        # Initialize an empty list to store the extracted features
        train_val = []
        for train_img in titles_compared: 
            train_val.append(train_image_features[train_img])
        train_images = np.array(train_val)
        features_linear = train_images.reshape(-1, train_images.shape[-1])

        #Gaussian mixture model
        gm = GaussianMixture(n_components=1, random_state=0).fit(features_linear)
        inv_cov = np.linalg.inv(gm.covariances_)

        dist_list=[]
        for train_img in titles_compared: 
            features2 = train_image_features[train_img]
            features2_linear = features2.reshape(-1, features2.shape[-1])
            maha = distance.cdist(gm.means_, features2_linear, 'mahalanobis', VI=inv_cov)
            dist_list.append(maha.max())
        dist_list = np.array(dist_list)
        threshold = dist_list.max()

        return gm, inv_cov, threshold

