# Screw/Bolt Tight vs. Loose Dataset (YOLO Format)

This repository contains a **manually annotated dataset** of **600 high-resolution images** for detecting screw and bolt conditions in industrial and assembly environments. Each image is labeled as **tight** or **loose** and is provided with corresponding YOLO-format annotation files.

## 📂 Dataset Structure

- Total images: `600`
- Splits: 
  - **Train:** 70% (~420 images)
  - **Validation:** 15% (~90 images)
  - **Test:** 15% (~90 images)

Each split contains:

/images  
 /labels

  
All annotations have been created manually to ensure high accuracy.

## ⚙️ Format

Annotations follow the standard YOLO format:   
<class_id> <x_center> <y_center> <width> <height>

Where:

- `class_id`: `0` for **tight**, `1` for **loose**
- Coordinates are normalized to image width and height.

## 🎯 Usage

This dataset is designed for training and benchmarking object-detection models (e.g. YOLOv5, YOLOv8) that aim to automatically classify screw and bolt states for manufacturing, quality control, and predictive maintenance tasks.

## ⏳ Coming Soon

This dataset will be publicly released soon. Stay tuned!