"""
===========================
Plot Pick and Place Dataset
===========================

The data is already preprocessed and normalized and stored in numpy's file
format.
"""
print(__doc__)
import numpy as np
import matplotlib.pyplot as plt
from mocap.conversion import dataframe_from_array
from mocap.plot import plot_streams_in_rows


trajectories = np.load("test/data/transfit_xsens_pickandplace/pickandplace_demonstrations.npy")
column_labels = list("XYZ") + ["QW", "QX", "QY", "QZ"]
df_trajectories = [dataframe_from_array(T.T, column_labels, dt=0.01) for T in trajectories]

plt.figure()
axes = None
for T in df_trajectories:
    axes = plot_streams_in_rows(trajectory=T, streams=column_labels, axes=axes)
plt.show()
