"""
==================
Plot Qualisys Data
==================

We use the high-level interface to load a tsv file, extract segments
and plot them.
"""
print(__doc__)
import numpy as np
import matplotlib.pyplot as plt
import mocap
from mocap.pandas_utils import match_columns
from mocap.orientation import orientation_from_three_positions
from mocap.cleaning import interpolate_nan
from mocap.plot import plot_segmented_streams_in_rows
from pytransform3d.trajectories import plot_trajectory

record = mocap.load(metadata="test/data/mymetadata.json")

swing_outs = record.get_segments_as_dataframes(
    label="swing_out", streams=["Hand .*", "Back .*"])

median_duration = mocap.durations_median(swing_outs)
swing_outs = mocap.scale_duration(swing_outs, median_duration, dt=1.0 / 15.0)
swing_outs = mocap.start_at_time_0(swing_outs)

plt.figure()
record.plot_streams_in_rows(["Hand .*", "Back .*"])

plt.figure()
plot_segmented_streams_in_rows(swing_outs, ["Hand .*", "Back .*"])

plt.figure()
ax = None
for swing_out in swing_outs:
    swing_out = interpolate_nan(swing_out)
    hand_top = mocap.array_from_dataframe(
        swing_out, match_columns(swing_out, ["Hand top .*"], keep_time=False))
    hand_left = mocap.array_from_dataframe(
        swing_out, match_columns(swing_out, ["Hand left .*"], keep_time=False))
    hand_right = mocap.array_from_dataframe(
        swing_out, match_columns(swing_out, ["Hand right .*"], keep_time=False))
    Q = orientation_from_three_positions(hand_top, hand_left, hand_right)
    P = np.hstack((hand_top, Q))
    ax = plot_trajectory(ax=ax, P=P, s=0.05, show_direction=False)

plt.show()
