"""
===============
Plot XSens Data
===============

The XSens data file contains a series of pick and place motions. We extract
all pick motions, normalize their durations and start positions, and plot
Cartesian hand trajectories.
"""
import mocap
from mocap.plot import plot_segmented_streams_in_rows
import matplotlib.pyplot as plt


record = mocap.load(
    metadata="test/data/myxsensmetadata.json",
    features=["position", "orientation"])

picks = record.get_segments_as_dataframes(
    label="pick", streams=["RightHand_position .*",
                           "RightHand_orientation .*"])

picks = mocap.start_at_time_0(picks, inplace=True)
median_duration = mocap.durations_median(picks)
picks = mocap.scale_duration(picks, median_duration, dt=1.0 / 60.0)
picks = mocap.start_at_origin(picks, "RightHand_position")

plt.figure()
plot_segmented_streams_in_rows(
    picks, ["RightHand_position .*", "RightHand_orientation .*"])
plt.show()
