"""
=======================
Visualize Qualisys Data
=======================

We use the high-level interface to load a tsv file, extract segments
and plot them.
"""
print(__doc__)
from pytransform3d import visualizer as pv
import mocap
from mocap.cleaning import interpolate_nan
from mocap.visualization import plot_markers

record = mocap.load(metadata="test/data/mymetadata.json")

swing_outs = record.get_segments_as_dataframes(
    label="swing_out", streams=["Hand .*", "Back .*"])

median_duration = mocap.durations_median(swing_outs)
swing_outs = mocap.scale_duration(swing_outs, median_duration, dt=1.0 / 15.0)

fig = pv.figure()
fig.plot_transform(s=0.5)
for swing_out in swing_outs:
    swing_out = interpolate_nan(swing_out)
    plot_markers(fig, swing_out, markers=["Hand top", "Hand left", "Hand right"],
                 colors=[(1, 0, 0), (0, 1, 0), (0, 0, 1)])
fig.view_init()
fig.show()
