"""Command line scripts."""
import argparse
import pprint
from . import interface


def mocap_info():
    parser = argparse.ArgumentParser()
    parser.add_argument(
        "metadata_filenames", type=str, nargs="*",
        help="Names of the mocap files to read.")
    parser.add_argument(
        "--list-streams", action="store_true", help="List streams.")
    parser.add_argument(
        "--summarize-labels", action="store_true",
        help="Summarize segment labels.")
    parser.add_argument(
        "--label-field", type=str, default="label",
        help="Name of the field in which the segment label is stored.")
    parser.add_argument(
        "--width", type=int, default=80, help="Line width of output.")
    args = parser.parse_args()

    printer = pprint.PrettyPrinter(width=args.width, compact=True)

    labels = []  # if args.summarize_labels

    for metadata_filename in args.metadata_filenames:
        print(f"Parsing file: {metadata_filename}")
        record = interface.load(metadata=metadata_filename)
        if args.list_streams:
            print("Available streams:")
            printer.pprint(record.get_available_streams())
        if args.summarize_labels:
            labels.extend(record.get_segment_names(args.label_field))

    if args.summarize_labels:
        print("Label occurrences:")
        unique_labels = set(labels)
        for unique_label in unique_labels:
            print(f"{unique_label}: {labels.count(unique_label)}")
