"""Data type conversions."""
import numpy as np
import pandas as pd


def dataframe_from_array(data, column_labels, dt=None):
    """Convert numpy array to pandas DataFrame.

    Parameters
    ----------
    data : array, shape (len(columns), n_steps)
        Time series data

    column_labels : list of str
        Labels for the columns

    dt : float, optional (default: None)
        If dt (read: delta t) is not None, we will create an additional column
        'Time'. We assume that samples are dt apart.

    Returns
    -------
    df : DataFrame
        Time series data
    """
    assert data.shape[0] == len(column_labels)
    df = pd.DataFrame(data=data.T, columns=column_labels)
    if dt is not None:
        df["Time"] = np.arange(len(df)) * dt
    return df


def array_from_dataframe(trajectory, columns):
    """Convert pandas DataFrame to numpy array.

    Parameters
    ----------
    trajectory : DataFrame
        Time series data

    columns : list of str
        Columns that should be extracted

    Returns
    -------
    array, shape (len(trajectories), len(columns))
        Extracted columns
    """
    return trajectory[columns].to_numpy()
