import getpass
import json


# TODO clone of trajectory_labeling
LABELED_BY = "labeled_by"
SUBJECT = "subject"
FREQUENCY = "frequency"
RECORD_FILENAME = "record_filename"
PLATFORM_TYPE = "platform_type"
FILE_COMMENT = "file_comment"
SEGMENTS = "segments"

START_FRAME = "start_frame"
END_FRAME = "end_frame"
MARKER = "marker"
NONE = "None"
START = "start"
END = "end"
L1 = "l1"
L2 = "l2"
LENGTH = "length"
LABEL = "label"
SECOND_LABEL = "second_label"


def save_metadata(filename, marker, trajectory, changepoints, output_filename):  # TODO test
    """Save metadata of a motion capture file.

    Parameters
    ----------
    filename : str
        Name of the motion capture data file

    marker : str
        Main marker that is relevant for segmentation

    trajectory : DataFrame
        Raw data (before downsampling) that has been used for segmentation.
        This dataframe has to contain at least the columns 'Time'.

    changepoints : array-like, shape (n_segments + 1)
        Segment borders. Starting at 0, ending at len(trajectory) - 1.

    output_filename : str
        Name of the output file. Ending should be '.json'.
    """
    out = dict()
    out[LABELED_BY] = getpass.getuser()  # current username
    out[SUBJECT] = None
    out[FREQUENCY] = None
    out[RECORD_FILENAME] = filename
    out[PLATFORM_TYPE] = ".{}".format(filename.split('.')[1])
    out[FILE_COMMENT] = None
    out[SEGMENTS] = []

    for start_idx, end_idx in zip(changepoints[:-1], changepoints[1:]):
        # create new segment and add it
        start_time = float(trajectory["Time"].iloc[start_idx])
        end_time = float(trajectory["Time"].iloc[end_idx])
        segment = {
            START_FRAME: start_idx,
            START: start_time,
            END_FRAME: end_idx,
            END: end_time,
            L1: "unknown",
            L2: "",
            LENGTH: int(end_idx) - int(start_idx),
            MARKER: marker
        }
        out[SEGMENTS].append(segment)

    with open(output_filename, "w") as f:
        json.dump(out, f, indent=4)
