"""Statistics of trajectories."""
import numpy as np


def durations(trajectories):
    """Compute durations of trajectories.

    Parameters
    ----------
    trajectories : list of DataFrame
        A collection of time series data

    Returns
    -------
    durations : list
        Durations of trajectories
    """
    return [t["Time"].iloc[-1] - t["Time"].iloc[0] for t in trajectories]


def durations_mean(trajectories):
    """Compute mean duration of trajectories.

    Parameters
    ----------
    trajectories : list of DataFrame
        A collection of time series data

    Returns
    -------
    mean : float
        Mean duration of trajectories
    """
    return np.mean(durations(trajectories))


def durations_median(trajectories):
    """Compute median duration of trajectories.

    Parameters
    ----------
    trajectories : list of DataFrame
        A collection of time series data

    Returns
    -------
    median : float
        Median duration of trajectories
    """
    return np.median(durations(trajectories))
