import numpy as np
from mocap.cache import identifier
from nose.tools import assert_equal, assert_not_equal


def test_identifier_is_equal():
    id1 = identifier(a="abc", b=1, c=(2, 3))
    id2 = identifier(a="abc", b=1, c=(2, 3))
    assert_equal(id1, id2)


def test_identifier_is_different():
    id1 = identifier(a="abc", b=1, c=(2, 3))
    id2 = identifier(a="ab", b=1, c=(2, 3))
    assert_not_equal(id1, id2)


def test_identifier_arglist():
    id1 = identifier("abc", 1, (2, 3))
    id2 = identifier(a="abc", b=1, c=(2, 3))
    assert_not_equal(id1, id2)


def test_identifier_numpy_arrays():
    id1 = identifier(d=np.zeros(4))
    id2 = identifier(d=np.ones(4))
    id3 = identifier(d=np.zeros(4))
    assert_not_equal(id1, id2)
    assert_equal(id1, id3)


def test_identifier_length():
    for i in range(100):
        assert_equal(len(identifier("abc", i, (i + 2, i + 3))), 32)
