import numpy as np
import mocap
from mocap import conversion
from nose.tools import assert_equal, assert_in


def test_array_from_dataframe():
    record = mocap.load(metadata="test/data/mymetadata.json")
    streams = record.get_available_streams()
    arr = conversion.array_from_dataframe(record.df, streams)
    assert_equal(arr.shape[0], 6235)
    assert_equal(arr.shape[1], len(streams))


def test_dataframe_from_array():
    arr = np.ones((3, 1000))
    df = conversion.dataframe_from_array(arr, ["X", "Y", "Z"], dt=0.001)
    assert_in("X", df.columns)
    assert_in("Y", df.columns)
    assert_in("Z", df.columns)
    assert_in("Time", df.columns)
