import numpy as np
try:
    from mocap.mano import HandState
except ImportError:
    from nose import SkipTest
    raise SkipTest("Open3D not available")
from nose.tools import assert_equal
from numpy.testing import assert_array_almost_equal


def test_create_mesh():
    left_hand = HandState(left=True)
    assert_equal(48, left_hand.n_pose_parameters)
    assert_equal(10, left_hand.n_shape_parameters)
    left_hand.set_pose_parameter(0, 1)
    for i in range(3, 48, 3):
        left_hand.set_pose_parameter(i, 0.2)
    left_hand.set_shape_parameter(5, 1)
    mesh = left_hand.hand_mesh
    assert_equal(len(mesh.vertices), 778)
    assert_array_almost_equal(
        mesh.vertices[427],
        np.array([0.061631, 0.022175, 0.007602]))

    right_hand = HandState(left=False)
    assert_equal(len(right_hand.hand_mesh.vertices), 778)
    assert_array_almost_equal(
        right_hand.hand_mesh.vertices[427],
        np.array([-0.062491,  0.012092, -0.010487]))


def test_create_pointclound():
    left_hand = HandState(left=True)
    pc = left_hand.hand_pointcloud
    assert_equal(len(pc.points), 778)
