import numpy as np
import mocap
from mocap.pandas_utils import match_columns
from mocap.orientation import orientation_from_three_positions
from mocap.cleaning import interpolate_nan
from numpy.testing import assert_array_almost_equal


def test_orientation_from_three_positions():
    record = mocap.load(metadata="test/data/mymetadata.json")

    swing_outs = record.get_segments_as_dataframes(
        label="swing_out", streams=["Hand .*", "Back .*"])

    median_duration = mocap.durations_median(swing_outs)
    swing_outs = mocap.scale_duration(
        swing_outs, median_duration, dt=1.0 / 15.0)
    swing_outs = mocap.start_at_time_0(swing_outs)

    for swing_out in swing_outs:
        swing_out = interpolate_nan(swing_out)
        hand_top = mocap.array_from_dataframe(
            swing_out, match_columns(swing_out, ["Hand top .*"],
                                     keep_time=False))
        hand_left = mocap.array_from_dataframe(
            swing_out, match_columns(swing_out, ["Hand left .*"],
                                     keep_time=False))
        hand_right = mocap.array_from_dataframe(
            swing_out, match_columns(swing_out, ["Hand right .*"],
                                     keep_time=False))
        Q = orientation_from_three_positions(hand_top, hand_left, hand_right)
        norms = np.linalg.norm(Q, axis=1)
        assert_array_almost_equal(norms, np.ones_like(norms))
