import numpy as np
import pandas as pd
from mocap.pandas_utils import merge_trajectories
from nose.tools import assert_equal


def test_merge_trajectories_first_last():
    t1 = pd.DataFrame({
        "Time": np.linspace(0.0, 1.0, 11),
        "x": np.arange(11)
    })
    t2 = pd.DataFrame({
        "Time": np.linspace(0.05, 1.05, 11),
        "y": np.arange(11)
    })
    t12 = merge_trajectories([t1, t2], start_time="first", end_time="last")
    assert_equal(len(t12), 22)
    assert_equal(t12["Time"].iloc[0], 0.0)
    assert_equal(t12["Time"].iloc[-1], 1.05)


def test_merge_trajectories_last_first():
    t1 = pd.DataFrame({
        "Time": np.linspace(0.0, 1.0, 11),
        "x": np.arange(11)
    })
    t2 = pd.DataFrame({
        "Time": np.linspace(0.05, 1.05, 11),
        "y": np.arange(11)
    })
    t12 = merge_trajectories([t1, t2], start_time="last", end_time="first")
    assert_equal(len(t12), 20)
    assert_equal(t12["Time"].iloc[0], 0.05)
    assert_equal(t12["Time"].iloc[-1], 1.0)
