#!/usr/bin/env python
from setuptools import setup
try:
    from Cython.Build import cythonize
    cython_available = True
except ImportError:
    cython_available = False
    import warnings


if __name__ == "__main__":
    with open("README.md", "r") as f:
        long_description = f.read()
    setup_config = dict(
        name='mocap',
        version="0.0",
        maintainer='Alexander Fabisch',
        maintainer_email='alexander.fabisch@dfki.de',
        description='Motion capture library',
        long_description=long_description,
        long_description_content_type="text/markdown",
        license='BSD-3-Clause',
        packages=['mocap'],
        package_data={"mocap": ["model/*"]},
        install_requires=["numpy", "scipy", "pandas", "pytransform3d",
                          "matplotlib"],
        extras_require={
            "all": ["cython", "open3d", "vtk"],
            "doc": ["numpydoc", "sphinx", "sphinx-gallery",
                    "sphinx-bootstrap-theme"],
            "test": ["nose", "coverage"]},
        entry_points={
            "console_scripts": ["mocap-info=mocap.command_line:mocap_info"]}
        )
    if cython_available:
        import numpy
        cython_config = dict(
            ext_modules=cythonize("mano_fast.pyx"),
            zip_safe=False,
            compiler_directives={'language_level': "3"},
            include_dirs=[numpy.get_include()],
            extra_compile_args=[
                "-O3",
                "-Wno-cpp", "-Wno-unused-function"
            ]
        )
        setup_config.update(cython_config)
    else:
        warnings.warn("Cython is not available. Install it if you want fast DMPs.")
    setup(**setup_config)
