import numpy as np
from mocap import qualisys, conversion, cleaning, pandas_utils
from nose.tools import assert_equal


def test_use_case_load_qualisys():
    trajectory = qualisys.read_qualisys_tsv("test/data/myqualisys.tsv", verbose=0)
    assert_equal(len(trajectory), 6235)
    assert_equal(len(trajectory.columns), 27)

    trajectory = pandas_utils.extract_markers(trajectory, ["Hand right", "Hand left", "Hand top"])
    assert_equal(len(trajectory.columns), 10)

    slices = [[2622, 2652], [4156, 4192], [4892, 4926], [5012, 5048]]
    segments = []
    for i in range(len(slices)):
        t_slice = qualisys.get_slice(trajectory, slice(*slices[i]))
        segments.append(t_slice)
    assert_equal(len(segments), 4)

    segment = segments[2]
    X = conversion.array_from_dataframe(
        segment, ["Hand right X", "Hand right Y", "Hand right Z"])
    assert_equal(X.shape[1], 3)
    assert np.any(np.isnan(X))

    X_cleaned = cleaning.interpolate_nan(X)
    assert not np.any(np.isnan(X_cleaned))