# Content

This folder contains non-public data required to run all examples of movement_primitives.

It is provided under the copyright of DFKI GmbH, Robotics Innovation Center and must not be distributed without permission. The dataset has been recorded by Dennis Mronga.

To use the data set (dataset.zip) in the examples, extract the folder "data" to the main folder of the movement_primitives repository.

To use the additional URDF files and code (movement_primitives_internal_deps.zip), extract it to the same location. Then you have to install the mocap library. Change to the folder and run "python -m pip install -e .".

## Example: Setup from Docker

### On Host System

*Note that the following setup is not sufficient to run simulation / visualization in the docker container!*

```bash
cd local_folder
git clone https://github.com/dfki-ric/movement_primitives.git
cd movement_primitives
# extract dataset.zip and movement_primitives_internal_deps.zip here
# mount "local_folder" at "folder_in_docker":
docker run -it -v local_folder:folder_in_docker ubuntu:22.04
```

### In Docker Container

```bash
apt update
apt install python3 python3-pip
# install movement_primitives
cd folder_in_docker/movement_primitives  # mounted from host
python3 -m pip install -e .[all]
# install mocap
cd mocap
python3 -m pip install -e .
# run examples...
```